%% INDIVIDUAL_VALIDATION
function [output] = individual_validation(output, generation, invalid_cnt, ...
                                          param, stats)
% Check solution validity     
% [OUTPUT] = INDIVIDUAL_VALIDATION(OUTPUT, GENERATION,
% INVALID_CNT, PARAM) checks if OUTPUT is valid for the femtocell
% simulation. Returns empty OUTPUT if it is invalid. Uses a strong taboo
% and disallows duplicate phenotypes.
%    OUTPUT is cellstring with the solution
%    GENERATION integer denoting current generation
%    INVALID_CNT integer denoting the number of invalids regenerated
%    PARAM struct of parameters
%    STATS struct of stats from the run

% TODO factor out taboo search to a method

%% Dissallow duplicate phenotypes
fs = stats.fitness_store(:); %Taboo for solutions in fitness store
if any(strcmp(sprintf('%s',output{:}), fs(1:2:end)))
    fprintf(param.FID,'WARNING map_individual %d %d PHENOTYPE_DUPLICATE: %s\n', generation, invalid_cnt, sprintf('%s',output{:}));
    output = {};
else
    % Check if valid phenotype. Valid given MATLAB evaluation, i.e. too many
    % function calls
    if ~isempty(output)
        try,
            eval(sprintf('%s',output{:}));
        catch, 
            fprintf(param.FID,'ERROR individual_validation %d EVAL %s\n', generation, sprintf('%s',output{:}));
            %disp(lasterror);
            output = {};
        end
    end
end
