function [output used_input input depth production_choice_ids stats] = ...
        map_individual(input, generation, param, stats)
% Map an individual

% [OUTPUT USED_INPUT INPUT DEPTH PRODUCTION_CHOICE_IDS] =
% MAP_INDIVIDUAL(INPUT, CFG, FITNESS_STORE, GENERATION) The input is mapped
% to output. The output is verified to be: completly expanded, not a
% duplicate of previous output, not only a constant and that the phenotype
% is valid. Returns the OUTPUT, the number of USED_INPUT, the INPUT (incase
% it has been regenerated), the DEPTH of the derivation and the
% PRODUCTION_CHOICE_IDS.
% INPUT the array for the input (genotype) used for mapping
% GENERATION the current generation
    
% TODO this function is problem dependant
% TODO hardcoded input variables to check for constants
    
invalid_cnt = 0;
output = {};

% Invalid mappings are re initialized randomly, until MAX_INVALID_REMAPS
while isempty(output) && invalid_cnt < param.MAX_INVALID_REMAPS
    [output used_input unexpanded_symbol_cnt unexpanded_symbols depth ...
     production_choice_ids] = map_input_to_output(input, param);
    %% Not completly expanded. This is default validation for GEMA
    if length(unexpanded_symbols) >= unexpanded_symbol_cnt
        fprintf(param.FID,'WARNING map_individual %d %d NON_TERMINALS_LEFT: %s\n', generation, invalid_cnt, sprintf('%s',output{:}));
        output = {};
    else
    end
    %% Validate individuals given the validate individual method provided
    if ~isempty(output)
       [output] = param.VALIDATE_INDIVIDUAL(output, generation, invalid_cnt, ...
                                            param, stats);
    end
    if isempty(output)
        invalid_cnt = invalid_cnt + 1;
        input = cell2mat(param.INITIALISATION(1, param));
        stats.mapping_cnt = stats.mapping_cnt + 1;
    end
end

%% MAP_INPUT_TO_OUTPUT
function [output used_input unexpanded_symbol_cnt unexpanded_symbols ...
          max_depth production_choice_ids] = map_input_to_output(input, ...
                                                      param)
% Map input to output using a grammar
% [OUTPUT USED_INPUT UNEXPANDED_SYMBOL_CNT UNEXPANDED_SYMBOLS MAX_DEPTH
% PRODUCTION_CHOICE_IDS] = MAP_INPUT_TO_OUTPUT(INPUT, CFG) The INPUT (genotype) is
% mapped using the CFG to OUTPUT (phenotype). Returns the OUTPUT, the
% number of USED_INPUT, the number of unexpanded symbols as
% UNEXPANDED_SYMBOL_CNT, the MAX_DEPTH of the derivation and the
% PRODUCTION_CHOICE_IDS. The derivation is performed using a stack based
% approach, were a counter is used to simulate a stack.
% INPUT the array for the input (genotype) used for mapping

% TODO Strange behaviour from different names of non-terminals, it gets stuck
% in an infinite loop if it is called e.g. <prog>, <code>

output = {};
unexpanded_symbols = {param.CFG.s};
depth_stack = 0;
current_depth = 0;
max_depth = 0;
production_choice_ids = [];
used_input = 0;
wraps = 0;

% Counter for the unexpanded symobls, since we do not remove any
unexpanded_symbol_cnt = 1;
depth_stack_cnt = 1;
while (wraps < param.MAX_WRAPS) && (length(unexpanded_symbols) >= unexpanded_symbol_cnt)
    %% Wrap
    if mod(used_input,length(input)) == 0 && used_input > 0 && length(production_choices) > 1
        wraps = wraps + 1;
    end
    %% Expand a production
    current_symbol = unexpanded_symbols{unexpanded_symbol_cnt};
    current_depth = depth_stack(depth_stack_cnt);
    
    %% Set output if it is a terminal. Faster by checking if the first char is <
    % TODO faster if a vairable for NT is used?
    if strncmp(current_symbol, '<', 1)
        % Find the rule by the index in the NTs
        rule_index = find(strcmp(param.CFG.s_NT, current_symbol));
        production_choices = param.CFG.rules{rule_index};
        %% Select a production
        current_production = mod(input(mod(used_input, length(input)) + 1), length(production_choices)) + 1;
        %% Use an input if there was more then 1 choice
        if length(production_choices) > 1
            used_input = used_input + 1;
        end
        %% Derviation ORDER is left to right(depth-first)
        chosen_production = production_choices{current_production};
        % Look up the production choice UID
        production_choice_ids = [production_choice_ids param.CFG.unique_production_choice_ids{1,rule_index}{current_production}];
        %% Insert the chosen production symbols in the unexpanded
        %% symbol list
        if length(unexpanded_symbols) >= (unexpanded_symbol_cnt + 1)
            unexpanded_symbols = {unexpanded_symbols{1:unexpanded_symbol_cnt} chosen_production{:} unexpanded_symbols{unexpanded_symbol_cnt + 1:end}};
            depth_stack = [depth_stack(1:depth_stack_cnt) ones(1,size(chosen_production,2)).*(current_depth+1) depth_stack(depth_stack_cnt + 1:end)];
        else
            unexpanded_symbols = {unexpanded_symbols{1:unexpanded_symbol_cnt} chosen_production{:}};
            depth_stack = [depth_stack(1:depth_stack_cnt) ones(1,size(chosen_production,2)).*(current_depth+1)];
        end
    else
        %% Add terminal to the output
        output = {output{:} current_symbol};
    end
	unexpanded_symbol_cnt = unexpanded_symbol_cnt + 1;
	depth_stack_cnt = depth_stack_cnt + 1;
    if max_depth < current_depth
        max_depth = current_depth;
    end
end

