function varargout = gem_gui(varargin)
% GEM_GUI M-file for gem_gui.fig
%      GEM_GUI, by itself, creates a new GEM_GUI or raises the existing
%      singleton*.
%
%      H = GEM_GUI returns the handle to a new GEM_GUI or the handle to
%      the existing singleton*.
%
%      GEM_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in GEM_GUI.M with the given input arguments.
%
%      GEM_GUI('Property','Value',...) creates a new GEM_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before gem_gui_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to gem_gui_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help gem_gui

% Last Modified by GUIDE v2.5 23-May-2011 15:25:34

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @gem_gui_OpeningFcn, ...
                   'gui_OutputFcn',  @gem_gui_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before gem_gui is made visible.
function gem_gui_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to gem_gui (see VARARGIN)

% Choose default command line output for gem_gui
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes gem_gui wait for user response (see UIRESUME)
% uiwait(handles.figure1);

 addpath('operators');

% --- Outputs from this function are returned to the command line.
function varargout = gem_gui_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in run_pb.
function run_pb_Callback(hObject, eventdata, handles)
% hObject    handle to run_pb (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Set parameters
params = get_params(handles);
% Call functions for running GEM
% Clear old files
if isfield(params,'SAVE_DIRECTORY_PATH') && exist(params.SAVE_DIRECTORY_PATH, 'dir')
    delete(strcat(params.SAVE_DIRECTORY_PATH, '/*'));
end
if ~isfield(params, 'RUNS')
    params.RUNS = 1;
end
params.BEST_INDIVIDUAL = handles.best_individual_st_1;
set(handles.idle_st, 'String', 'Busy');
set(handles.idle_st, 'ForegroundColor', 'r');
for i = 1:params.RUNS    
    axes(handles.fitness_a);
    cla;
    hold off;
    xlabel('Generation');
    ylabel('Fitness');
    set(handles.fitness_a,'XMinorTick', 'on');
    
    axes(handles.other_a);
    cla;
    hold off;
    ylabel('Used codons');
    xlabel('Generation');
    set(handles.other_a,'XMinorTick', 'on');
    
    axes(handles.other_a_1);
    cla;
    hold off;
    %TODO is ratio a good name?
    ylabel('Ratio');
    xlabel('Generation');
    set(handles.other_a,'XMinorTick', 'on');
    
    params.FITNESS_PLOT = handles.fitness_a;
    params.OTHER_PLOT = handles.other_a;
    params.OTHER_PLOT_1 = handles.other_a_1;
    params.RUN = i;
    gema(params);
end
set(handles.idle_st, 'String', 'Idle');
set(handles.idle_st, 'ForegroundColor', 'g');
% Activate graphs

% --- Executes on selection change in problems_pm.
function problems_pm_Callback(hObject, eventdata, handles)
% hObject    handle to problems_pm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns problems_pm contents as cell array
%        contents{get(hObject,'Value')} returns selected item from problems_pm
value = get(handles.problems_pm,'Value');
switch value
  case 1
    problem = '';
  case 2
    addpath('financial_modelling');
    problem = @financial_modelling_config;
  case 3
    addpath('multiobjective_function');
    problem = @multiobjective_function_config;
  case 4
    addpath('symbolic_regression');
    problem = @symbolic_regression_config;
  case 5
    addpath('symbolic_regression_multicore');
    problem = @symbolic_regression_multicore_config;
  otherwise
    throw(MException('gem_gui.problems_pm_Callback:IllegalArgument','IllegalArgument'));
end
setappdata(gem_gui,'PROBLEM',problem);

% --- Executes during object creation, after setting all properties.
function problems_pm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to problems_pm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes during object creation, after setting all properties.
function run_pb_CreateFcn(hObject, eventdata, handles)
% hObject    handle to run_pb (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


function grammar_et_Callback(hObject, eventdata, handles)
% hObject    handle to grammar_et (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of grammar_et as text
%        str2double(get(hObject,'String')) returns contents of grammar_et as a double

FilePath = get(handles.grammar_et, 'String');
set(handles.grammar_et, 'String', FilePath);
setappdata(gem_gui, 'GRAMMAR_FILE', FilePath);

% --- Executes during object creation, after setting all properties.
function grammar_et_CreateFcn(hObject, eventdata, handles)
% hObject    handle to grammar_et (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in grammar_pb.
function grammar_pb_Callback(hObject, eventdata, handles)
% hObject    handle to grammar_pb (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% get a file to read 
[FileName, FilePath] = uigetfile({ '*.bnf';}, 'Select a grammar...');
% set the file name and path to the edit box as well
set(handles.grammar_et, 'String', [FilePath, FileName]);
setappdata(gem_gui, 'GRAMMAR_FILE_PATH', [FilePath, FileName]);
   
% --- Executes on selection change in mutation_pm.
function mutation_pm_Callback(hObject, eventdata, handles)
% hObject    handle to mutation_pm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns mutation_pm contents as cell array
%        contents{get(hObject,'Value')} returns selected item from mutation_pm
value = get(handles.mutation_pm,'Value');
switch value
  case 1
    mutation = '';
  case 2
    mutation = @uniform_integer_mutation;
  case 3
    mutation = @integer_extended_nodal_mutation
    mutation_pr = get(handles.mutation_s, 'Value');
    mutation_pr = mutation_pr * 100;
    set(handles.mutation_st_value, 'String', num2str(round(mutation_pr)));
    setappdata(gem_gui,'MUTATION_PROBABILITY',mutation_pr);
  otherwise
    throw(MException('gem_gui.mutation_pm_Callback:IllegalArgument','IllegalArgument'));
end
    %disp(mutation)
setappdata(gem_gui,'MUTATION_OPERATION',mutation);

% --- Executes during object creation, after setting all properties.
function mutation_pm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to mutation_pm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on slider movement.
function mutation_s_Callback(hObject, eventdata, handles)
% hObject    handle to mutation_s (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
value = get(hObject, 'Value');
if get(handles.mutation_pm, 'Value') == 3
    value = value * 100;        
end
set(handles.mutation_st_value, 'String', num2str(value));
setappdata(gem_gui,'MUTATION_PROBABILITY',value);

% --- Executes during object creation, after setting all properties.
function mutation_s_CreateFcn(hObject, eventdata, handles)
% hObject    handle to mutation_s (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end

% --- Executes on selection change in crossover_pm.
function crossover_pm_Callback(hObject, eventdata, handles)
% hObject    handle to crossover_pm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns crossover_pm contents as cell array
%        contents{get(hObject,'Value')} returns selected item from crossover_pm
value = get(handles.crossover_pm,'Value');
switch value
  case 1
    crossover = '';
  case 2
    crossover = @single_point_crossover;
  otherwise
    throw(MException('gem_gui.crossover_pm_Callback:IllegalArgument','IllegalArgument'));
end 
%disp(crossover);
setappdata(gem_gui,'CROSSOVER_OPERATION',crossover);

% --- Executes during object creation, after setting all properties.
function crossover_pm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to crossover_pm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on slider movement.
function crossover_s_Callback(hObject, eventdata, handles)
% hObject    handle to crossover_s (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
value = get(hObject, 'Value');
set(handles.crossover_st_value, 'String', num2str(value));
setappdata(gem_gui,'CROSSOVER_PROBABILITY',value);

% --- Executes during object creation, after setting all properties.
function crossover_s_CreateFcn(hObject, eventdata, handles)
% hObject    handle to crossover_s (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on selection change in replacement_pm.
function replacement_pm_Callback(hObject, eventdata, handles)
% hObject    handle to replacement_pm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns replacement_pm contents as cell array
%        contents{get(hObject,'Value')} returns selected item from replacement_pm
value = get(handles.replacement_pm,'Value');
visibility = 'off';
switch value
  case 1
    replacement = '';
  case 2
    replacement = @generational_replacement;
    visibility = 'on';
  case 3
    replacement = @replacement_nsga2;
  otherwise
    throw(MException('gem_gui.replacement_pm_Callback:IllegalArgument','IllegalArgument'));
end
set(handles.elite_size_st, 'Visible', visibility);
set(handles.elite_size_s, 'Visible', visibility);
set(handles.elite_size_number_st, 'Visible', visibility);
%disp(replacement);
setappdata(gem_gui,'REPLACEMENT',replacement);


% --- Executes during object creation, after setting all properties.
function replacement_pm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to replacement_pm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on slider movement.
function elite_size_s_Callback(hObject, eventdata, handles)
% hObject    handle to elite_size_s (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
value = get(hObject, 'Value');
setappdata(gem_gui,'elite_size_s',value);
population_size = getappdata(gem_gui,'POPULATION_SIZE');
if isempty(population_size)
    user_response = errordlg('Please explicitly specify Population size');
    population_size = 0;
end
elite_size = ceil(value * population_size);
set(handles.elite_size_number_st, 'String', num2str(elite_size));
setappdata(gem_gui,'ELITE_SIZE',elite_size);

% --- Executes during object creation, after setting all properties.
function elite_size_s_CreateFcn(hObject, eventdata, handles)
% hObject    handle to elite_size_s (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end



function population_size_et_Callback(hObject, eventdata, handles)
% hObject    handle to population_size_et (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of population_size_et as text
%        str2double(get(hObject,'String')) returns contents of population_size_et as a double

value = get(handles.population_size_et,'String');
setappdata(gem_gui,'POPULATION_SIZE',str2num(value));
value = get(handles.elite_size_s, 'Value');
population_size = getappdata(gem_gui,'POPULATION_SIZE');
elite_size = ceil(value * population_size);
set(handles.elite_size_number_st, 'String', num2str(elite_size));
setappdata(gem_gui,'ELITE_SIZE',elite_size);

% --- Executes during object creation, after setting all properties.
function population_size_et_CreateFcn(hObject, eventdata, handles)
% hObject    handle to population_size_et (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function generations_et_Callback(hObject, eventdata, handles)
% hObject    handle to generations_et (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of generations_et as text
%        str2double(get(hObject,'String')) returns contents of generations_et as a double

value = get(handles.generations_et,'String');
setappdata(gem_gui,'GENERATIONS',str2num(value));

% --- Executes during object creation, after setting all properties.
function generations_et_CreateFcn(hObject, eventdata, handles)
% hObject    handle to generations_et (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in tournament_selection_pm.
function tournament_selection_pm_Callback(hObject, eventdata, handles)
% hObject    handle to tournament_selection_pm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns tournament_selection_pm contents as cell array
%        contents{get(hObject,'Value')} returns selected item from tournament_selection_pm
value = get(handles.tournament_selection_pm,'Value');
visibility = 'off';
switch value
  case 1
    selection = '';
  case 2
    selection = @tournament_selection;
    visibility = 'on';
  case 3
    selection = @tournament_selection_nsga2;
    visibility = 'on';
  otherwise
    throw(MException('gem_gui.selection_pm_Callback:IllegalArgument','IllegalArgument'));
end
set(handles.tournament_size_st, 'Visible', visibility);
set(handles.tournament_size_et, 'Visible', visibility);
%disp(selection);
setappdata(gem_gui,'SELECTION',selection);

% --- Executes during object creation, after setting all properties.
function tournament_selection_pm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tournament_selection_pm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function tournament_size_et_Callback(hObject, eventdata, handles)
% hObject    handle to tournament_size_et (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tournament_size_et as text
%        str2double(get(hObject,'String')) returns contents of tournament_size_et as a double

value = get(handles.tournament_size_et,'String');
setappdata(gem_gui,'TOURNAMENT_SIZE',str2num(value));

% --- Executes during object creation, after setting all properties.
function tournament_size_et_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tournament_size_et (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in initialisation_pm.
function initialisation_pm_Callback(hObject, eventdata, handles)
% hObject    handle to initialisation_pm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns initialisation_pm contents as cell array
%        contents{get(hObject,'Value')} returns selected item from initialisation_pm
value = get(handles.initialisation_pm,'Value');
switch value
  case 1
    initialisation = '';
    visibility = 'off';
    set(handles.max_depth_et, 'Visible', visibility);
    set(handles.max_depth_st, 'Visible', visibility);
    set(handles.tail_size_et, 'Visible', visibility);
    set(handles.tail_size_st, 'Visible', visibility);
  case 2
    initialisation = @uniform_initialisation;
    visibility = 'on';
    set(handles.max_depth_et, 'Visible', visibility);
    set(handles.max_depth_st, 'Visible', visibility);
    set(handles.max_depth_st, 'String', 'Size');
    visibility = 'off';
    set(handles.tail_size_et, 'Visible', visibility);
    set(handles.tail_size_st, 'Visible', visibility);
  case 3
    initialisation = @ramped_half_half_initialisation;
    visibility = 'on';
    set(handles.max_depth_et, 'Visible', visibility);
    set(handles.max_depth_st, 'Visible', visibility);
    set(handles.max_depth_st, 'String', 'Max Depth');
    set(handles.tail_size_et, 'Visible', visibility);
    set(handles.tail_size_st, 'Visible', visibility);
  otherwise
    throw(MException('gem_gui.initialisation_pm_Callback:IllegalArgument','IllegalArgument'));
end
%disp(initialisation);
setappdata(gem_gui,'INITIALISATION',initialisation);

% --- Executes during object creation, after setting all properties.
function initialisation_pm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to initialisation_pm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function max_depth_et_Callback(hObject, eventdata, handles)
% hObject    handle to max_depth_et (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of max_depth_et as text
%        str2double(get(hObject,'String')) returns contents of max_depth_et as a double

value = get(handles.max_depth_et,'String');
type = get(handles.max_depth_st,'String');
if strcmp(type,'Size')
    setappdata(gem_gui,'INITIAL_CHROMOSOME_SIZE',str2num(value));
else
    setappdata(gem_gui,'MAX_DEPTH',str2num(value));
end

% --- Executes during object creation, after setting all properties.
function max_depth_et_CreateFcn(hObject, eventdata, handles)
% hObject    handle to max_depth_et (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function tail_size_et_Callback(hObject, eventdata, handles)
% hObject    handle to tail_size_et (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tail_size_et as text
%        str2double(get(hObject,'String')) returns contents of tail_size_et as a double

value = get(handles.tail_size_et,'String');
setappdata(gem_gui,'TAIL_SIZE',str2num(value));

% --- Executes during object creation, after setting all properties.
function tail_size_et_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tail_size_et (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in parismony_pressure_cb.
function parismony_pressure_cb_Callback(hObject, eventdata, handles)
% hObject    handle to parismony_pressure_cb (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of parismony_pressure_cb
if (get(hObject,'Value') == get(hObject,'Max'))
    setappdata(gem_gui, 'PARISMONY_PRESSURE', 1);
else
    setappdata(gem_gui, 'PARISMONY_PRESSURE', 0);
end

function save_directory_et_Callback(hObject, eventdata, handles)
% hObject    handle to save_directory_et (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of save_directory_et as text
%        str2double(get(hObject,'String')) returns contents of save_directory_et as a double

DirName = get(handles.save_directory_et, 'String');
set(handles.save_directory_et, 'String', DirName);
setappdata(gem_gui, 'SAVE_DIRECTORY_PATH', DirName);

% --- Executes during object creation, after setting all properties.
function save_directory_et_CreateFcn(hObject, eventdata, handles)
% hObject    handle to save_directory_et (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in save_directory_pb.
function save_directory_pb_Callback(hObject, eventdata, handles)
% hObject    handle to save_directory_pb (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% get a file to read 
DirName = uigetdir(pwd(), 'Select a directory...');
% set the file name and path to the edit box as well
set(handles.save_directory_et, 'String', DirName);
setappdata(gem_gui, 'SAVE_DIRECTORY_PATH', DirName);

function runs_et_Callback(hObject, eventdata, handles)
% hObject    handle to runs_et (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of runs_et as text
%        str2double(get(hObject,'String')) returns contents of runs_et as a double

value = get(handles.runs_et,'String');
setappdata(gem_gui,'RUNS',str2num(value));

% --- Executes during object creation, after setting all properties.
function runs_et_CreateFcn(hObject, eventdata, handles)
% hObject    handle to runs_et (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function params = get_params(handles)
%Get the params from the handles
    
gui_params = getappdata(gem_gui);
disp(gui_params);
% Call the problem
params = gui_params.PROBLEM(struct());
param_names = fieldnames(gui_params);
for i = 1:size(param_names,1)
    gui_param_name = param_names{i}
    gui_param = getfield(gui_params, gui_param_name);
    params = setfield(params, gui_param_name, gui_param);
    disp(getfield(params, gui_param_name))
end
disp(params)


% --- Executes on button press in exit_pb.
function exit_pb_Callback(hObject, eventdata, handles)
% hObject    handle to exit_pb (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close all;
