function fitness = trading_fitness(daily_returns, signals)
% Calculate the fitness when trading with buy and sell signals    
% FITNESS = TRADING_FITNESS(DAILY_RETURNS, SIGNALS) sum elements from each
% point in the time-series for daily returns by multiplying the signal (1 or
% -1) that was generated in day t-1 with the daily return of day t. The you
% get the average by diving with the number of training days. This quantity
% should be maximised. Returns FITNESS from trading
%    DAILY_RETURNS - data used for trading
%    SIGNALS - Buy(1) and sell(-1) signals
    
sum_ = sum(signals .* daily_returns);
fitness = sum_ ./size(daily_returns, 1);