function sma = simple_moving_average(data, window, t)
% Calculate simple moving average of the data with the window size
% SMA = SIMPLE_MOVING_AVERAGE(DATA, WINDOW, T) Calculate simple moving
% average of the DATA with the WINDOW size. A window for time T is
% returned if T is specified.
%    DATA - data to calculate sma over
%    WINDOW - window size for the sma
%    T - value taken from the window

%cumulative sum of the data divided by the window size
sma = cumsum(data)/window;
%handle 
sma(window+1:end) = sma(window+1:end) - sma(1:end - window);
if nargin == 3
    sma(t);
else 
    sma;
end