function [new_pop stats] = financial_modelling_ff(xo_pop, ...
    settings, generation, param, stats)
% Calls the fitness function for financial modelling
% [NEW_POP FITNESS_STORE] = FINANCIAL_MODELLING(XO_POP, SETTINGS, CFG,
% INITIALISATION, GENERATION) Calls the fitness function and checks the
% fitness to see how many needs to be recalculated. Returns the new
% population, NEW_POP and the updated STATS. 
%    XO_POP cell array of population to evaluate 
%    SETTINGS struct for MULTICORE settings 
%    GENERATION integer denoting the current generation
%    PARAM struct with parameters
%    STATS struct with run stats

data = param.data;
daily_returns = param.daily_returns;
smas = param.smas;
new_pop = xo_pop;

for i = 1:size(new_pop,1) 
    item.expression = xo_pop(i).OUTPUT_C;    
    % Check if expression is cached
    fitness_i = [];
    if ~isempty(stats.fitness_store)
        fs = stats.fitness_store(:);
        fitness_i = find(strcmp(fs(1:2:end), item.expression));
    end
    if ~isempty(fitness_i)
        new_pop(i).FITNESS_C = fitness_i;
    else
        signals = zeros(size(data,1),1);
        eval(item.expression);
        item.fitness = trading_fitness(daily_returns, signals);
        stats.fitness_store = [stats.fitness_store struct2cell(item)];
        new_pop(i).FITNESS_C = item.fitness;
    end
end
