function param = financial_modelling_config(param)
% Configurations for financial modelling problem
    
% FINANCIAL_MODELLING_CONFIG(PARAM) configurations for financial modelling
% problem. Sets and returns the problem dependent PARAMs
    

param.ORDER = 'descend';
param.MAX_WRAPS = 2;
param.CODON_SIZE = 128;
param.POPULATION_SIZE = 40;
param.INITIAL_CHROMOSOME_SIZE = 200;
param.GENERATIONS = 20;
param.TOURNAMENT_SIZE = 3;
param.CROSSOVER_PROBABILITY = 0.7;
param.CROSSOVER_OPERATION = @single_point_crossover;
param.MUTATION_PROBABILITY = 0.05;
param.MUTATION_OPERATION = @uniform_integer_mutation;
param.EXTENDED_NODAL_PROBABILITY = 0.5;
param.EXTENDED_NODAL_TRIES = 1000;
param.ELITE_SIZE = 2;
param.PARISIMONY_PREASSURE = 1;
param.MAX_DEPTH = 5;
param.GROW_PROBABILITY = 0.5;
param.TAIL_SIZE = 1.0;
param.FEVALS_TIMES_SINGLE = 10 * 60;
param.NEVALS_AT_ONCE = 1;
param.SAVE_POPULATION = 'test_population_save.dat';
param.INITIALISATION = @uniform_initialisation;
param.SELECTION = @tournament_selection;
param.REPLACEMENT = @generational_replacement;
param.MIN_FITNESS = -inf;
    
param.FITNESS_FUNCTIONS = 1;
param.INDIVIDUAL_STRUCT = struct('INPUT_C', [], 'OUTPUT_C', [], ...
                                 'FITNESS_C', [], 'USED_INPUT_C', [], ...
                                 'DEPTH_C', [], ...
                                 'PRODUCTION_CHOICE_IDS_C', []);
param.DATA = 'financial_modelling/table.csv';
param.GRAMMAR_FILE = 'grammars/trade_rules.bnf';
param.VALIDATE_INDIVIDUAL = @individual_validation;
param.FITNESS_EVALUATION_METHOD = @financial_modelling_ff;
param.data = dlmread(param.DATA, ',', 1,1);
param.data = param.data(1:end,end);
disp(param.data)
% Precalculating the moving averages for improving speed. This increases
% the memory usage
param.smas = zeros(size(param.data,1), 100);
for i = 1:100
    param.smas(:,i) = simple_moving_average(param.data, i);
end
param.daily_returns = daily_return(param.data);
    