function dr = daily_return(prices)
% Calculates the daily return dr = (p(t) - p(t-1)/p(t-1)

% DR = DAILY_RETURN(PRICES, DAY)

% DR - daily return
% PRICES - prices
% DAY - day
previous_prices = [prices(2:end); prices(end)];
dr = (prices - previous_prices)./previous_prices; 