function ind = create_individual(inputs, param)
% Creates a new individual

% IND = CREATE_INDIVIDUAL(INPUTS, PARAM) creates a new individual with the
% INPUTS

% INPUTS is the integer array (genotype) used for mapping the
% output(phenotype)
% PARAM struct with parameters

    if iscell(inputs)
        ind.INPUT_C = cell2mat(inputs);
    else
        ind.INPUT_C = inputs;
    end
    ind.OUTPUT_C = {};
    ind.FITNESS_C = param.MIN_FITNESS.*ones(1,param.FITNESS_FUNCTIONS);
    ind.USED_INPUT_C = NaN;
    if(param.IND_SIZE > 6)
        ind.RANK_C = 1;
        ind.DISTANCE_C = 0;
    end
    ind.DEPTH_C = 0;
    ind.PRODUCTION_CHOICE_IDS_C = [];

